// @flow
import React, { Component } from 'react';
import {auth, provider, providerGoogle} from './components/firebase/index.js'
import Media from './components/media/index.js'

import 'semantic-ui/dist/components/reset.css'
import 'semantic-ui/dist/semantic.min.css'
import 'semantic-ui/dist/components/icon.css'
import 'semantic-ui/dist/components/segment.css'
import 'semantic-ui/dist/components/button.css'
import 'semantic-ui/dist/components/menu.css'
import './App.css';

type Props = {
    /* */
}

type State = {
    user: string,
    activeLink: string,
    loginStatus: number
}

class App extends Component<Props, State> {
    state = {
        user: null,
        activeLink: 'Home',
        loginStatus: 0
    }

    async login() {
        const result = await auth().signInWithPopup(provider)
        this.setState({user: result.user})
    }

    async loginGoogle() {
        const result = await auth().signInWithPopup(providerGoogle)
        this.setState({user: result.user})
    }

    async logout() {
        await auth().signOut()
        this.setState({user: null})
    }

    async componentWillMount() {
        auth().onAuthStateChanged((user) => {
            if(user) this.setState({user})
        })
    }

    render() {
        const {user} = this.state

        const navLinks = [
            ['Home','/'],
            ['The list','/blank/undef']
        ]

        return (
            <div className='App'>
                <Media user='Marc Fehr' />
            </div>
        );
    }
}

export default App;
