// @flow

import * as React from 'react';

import 'semantic-ui/dist/semantic.min.css'

type Props = {
    user: string
};

type State = {
    actualUser: string,
    count: number
}

class Media extends React.Component<Props> {
    static defaultProps = {
        user: 'Unbekannter Nutzer'
    };

    state = {
        actualUser: this.props.user,
        count: 0
    }

    setName (user) {
    	this.setState({
    		actualUser: user,
			count: this.state.count + 1
    	})
    }

    render () {
        return(
            <div>
	            <h3
	                className="ui header"
	            >
	               Du befindest dich jetzt in der Media-Component. Dein User-Prop, 
	               das du mitgegeben hast, heisst:
	            </h3>
	            <h3>
	            	{this.props.user}
	            </h3>
	            {this.state.count > 0 &&
            	    <h3>Nach dem Klick wurde der State geändert. Der User heisst
		            jetzt neu: {this.state.actualUser}</h3>
	            }
	            <h2>Du hast bisher {this.state.count} Mal geklickt</h2>
				<button 
					onClick={() => this.setName('Martin Vollenweider')} 
				>
					Hier klicken
				</button>
			</div>
        )
    }
}

export default Media